#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
#include <iomanip>

using namespace std;
using ll = long long;

struct Item {
    int id;
    ll w, v;
};

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n_in;
    ll W;
    double eps;

    if (!(cin >> n_in >> W >> eps)) return 0;

    vector<Item> a;
    ll max_v = 0;

    for (int i = 0; i < n_in; ++i) {
        ll w, v;
        cin >> w >> v;
        if (w <= W) {
            a.push_back({i + 1, w, v});
            if (v > max_v) max_v = v;
        }
    }

    int n = a.size();
    if (n == 0) {
        cout << "0\n\n";
        return 0;
    }
    long double k_calc = (eps * (long double)max_v) / (long double)n;
    ll K = (ll)floor(k_calc);
    if (K < 1) K = 1;

    ll S = 0;
    for (auto& x : a) S += x.v / K;

    vector<ll> dp(S + 1, W + 1);
    dp[0] = 0;
    vector<bool> keep;
    try {
        keep.resize((ll)n * (S + 1), false);
    } catch (...) { return 0; }

    ll cur_max = 0;

    for (int i = 0; i < n; ++i) {
        ll w = a[i].w;
        ll v = a[i].v / K;

        for (ll j = cur_max; j >= 0; --j) {
            if (dp[j] <= W) {
                ll nv = j + v;
                ll nw = dp[j] + w;

                if (nv <= S && nw <= W && nw < dp[nv]) {
                    dp[nv] = nw;
                    keep[(ll)i * (S + 1) + nv] = true;
                }
            }
        }
        cur_max += v;
        if (cur_max > S) cur_max = S;
    }

    ll res = cur_max;
    while (res > 0 && dp[res] > W) res--;

    vector<int> out;
    for (int i = n - 1; i >= 0; --i) {
        if (keep[(ll)i * (S + 1) + res]) {
            out.push_back(a[i].id);
            res -= a[i].v / K;
        }
    }

    sort(out.begin(), out.end());

    cout << out.size() << "\n";
    for (int i = 0; i < out.size(); ++i) {
        cout << out[i] << (i == out.size() - 1 ? "" : " ");
    }
    cout << "\n";

    return 0;
}